/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.fideicomiso.valores.ModeloValoresBeneficiario;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.BeneficioRetencion;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.ComponenteFiscalidad;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wb.swt.SWTResourceManager;

public class DialogoInfoBeneficiario
extends DialogoBase
implements VistaModelo<BeneficioRetencion>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private BeneficioRetencion modeloDatos;
    private ModeloValoresBeneficiario modeloValores;
    private final Periodo periodo;
    private List<Sujeto> beneficiariosExistentes;
    private Sujeto beneficiarioActual = new Sujeto();
    private boolean editando;
    private Text txtNumIdentificacion;
    private Text txtPorcentajeRetencion;
    private Text txtMontoIndividual;
    private Text txtMontoRetencion;
    private ComboViewer cvPago;
    private Button btnConvenioSi;
    private Button btnConvenioNo;
    private Button btnRetencionSi;
    private Button btnRetencionNo;
    private ComboViewer cvTipoIdentificacion;
    private Combo cmbPago;
    private Composite panelBotonesPr;
    private Label lblParteRelacionada;
    private Button btnSiPr;
    private Button btnNoPr;
    private Text txtImpRentaDiv;
    private Text txtAnioGenUtilDiv;
    private Button btnPagRegFis_SI;
    private Button btnPagRegFis_NO;
    private Text txtRazonSocial;
    private ComboViewer cvBeneficiario;
    private Label lblRazonSocial;
    private Combo cmbTipoDeBeneficiario;
    private Label lblTipoDeBeneficiario;
    private ComponenteFiscalidad compFiscalidad;
    private Label lblPagoRegimenFiscal;
    private Composite panelPagoRegFiscal;

    public DialogoInfoBeneficiario(IWorkbenchPartSite site, List<Sujeto> beneficiariosExistentes, boolean editando, Periodo periodo) {
        super(site);
        this.setShellStyle(80);
        this.beneficiariosExistentes = beneficiariosExistentes;
        this.editando = editando;
        this.periodo = periodo;
    }

    public void setModeloDatos(BeneficioRetencion modeloDatos) {
        this.modeloDatos = modeloDatos;
        this.compFiscalidad = new ComponenteFiscalidad(modeloDatos.getPagoLocalExterior(), this.periodo);
        if (this.editando) {
            this.beneficiarioActual = modeloDatos.getBeneficiario();
        }
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresBeneficiario();
        this.modeloValores.inicializar();
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Ingrese la informaci\u00f3n del  Beneficiario");
        this.setTitle("Detalle del Beneficiario");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblInformacinDelBeneficiario = new Label(container, 0);
        lblInformacinDelBeneficiario.setText("Informaci\u00f3n del Beneficiario");
        lblInformacinDelBeneficiario.setFont(SWTResourceManager.getBoldFont((Font)lblInformacinDelBeneficiario.getFont()));
        new Label(container, 0);
        Label lblTipoIdentificacinBeneficiario = new Label(container, 0);
        GridData gd_lblTipoIdentificacinBeneficiario = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoIdentificacinBeneficiario.widthHint = 180;
        lblTipoIdentificacinBeneficiario.setLayoutData((Object)gd_lblTipoIdentificacinBeneficiario);
        lblTipoIdentificacinBeneficiario.setText("Tipo Identificaci\u00f3n Beneficiario");
        this.cvTipoIdentificacion = new ComboViewer(container, 8);
        this.manejarSeleccionComboTipoIdBeneficiario();
        Combo combo_2 = this.cvTipoIdentificacion.getCombo();
        GridData gd_combo_2 = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo_2.widthHint = 120;
        combo_2.setLayoutData((Object)gd_combo_2);
        Label lblNIdentificacin = new Label(container, 0);
        lblNIdentificacin.setText("N\u00b0 identificaci\u00f3n");
        this.txtNumIdentificacion = new Text(container, 2048);
        this.txtNumIdentificacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoInfoBeneficiario.this.txtNumIdentificacion.selectAll();
            }
        });
        this.txtNumIdentificacion.setTextLimit(13);
        GridData gd_txtNumIdentificacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtNumIdentificacion.widthHint = 100;
        this.txtNumIdentificacion.setLayoutData((Object)gd_txtNumIdentificacion);
        this.lblParteRelacionada = new Label(container, 0);
        this.lblParteRelacionada.setVisible(true);
        this.lblParteRelacionada.setText("Es Parte Relacionada");
        this.panelBotonesPr = new Composite(container, 0);
        GridLayout gl_panelBotonesPr1 = new GridLayout(2, false);
        gl_panelBotonesPr1.marginWidth = 0;
        gl_panelBotonesPr1.marginHeight = 0;
        this.panelBotonesPr.setLayout((Layout)gl_panelBotonesPr1);
        this.btnSiPr = new Button(this.panelBotonesPr, 16);
        GridData gd_btnSiPr = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnSiPr.widthHint = 50;
        this.btnSiPr.setLayoutData((Object)gd_btnSiPr);
        this.btnSiPr.setText("SI");
        this.btnNoPr = new Button(this.panelBotonesPr, 16);
        GridData gd_btnNoPr = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnNoPr.widthHint = 50;
        this.btnNoPr.setLayoutData((Object)gd_btnNoPr);
        this.btnNoPr.setText("NO");
        this.lblTipoDeBeneficiario = new Label(container, 0);
        GridData gd_lblTipoDeBeneficiario = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoDeBeneficiario.widthHint = 330;
        this.lblTipoDeBeneficiario.setLayoutData((Object)gd_lblTipoDeBeneficiario);
        this.lblTipoDeBeneficiario.setVisible(false);
        this.lblTipoDeBeneficiario.setText("Tipo de Beneficiario");
        this.cvBeneficiario = new ComboViewer(container, 8);
        this.cvBeneficiario.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoContribuyente = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoContribuyente != null) {
                    DialogoInfoBeneficiario.this.modeloDatos.getBeneficiario().setTipoProveedor((String)tipoContribuyente.getValor());
                    DialogoInfoBeneficiario.this.modeloDatos.getBeneficiario().setDescripcionTipoProveedor(tipoContribuyente.getNombre());
                }
            }
        });
        this.cmbTipoDeBeneficiario = this.cvBeneficiario.getCombo();
        this.cmbTipoDeBeneficiario.setVisible(false);
        this.cmbTipoDeBeneficiario.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblRazonSocial = new Label(container, 0);
        GridData gd_lblRazonSocial = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRazonSocial.widthHint = 300;
        this.lblRazonSocial.setLayoutData((Object)gd_lblRazonSocial);
        this.lblRazonSocial.setVisible(false);
        this.lblRazonSocial.setText("Raz\u00f3n o denominaci\u00f3n social del beneficiario");
        this.txtRazonSocial = new Text(container, 2048);
        this.txtRazonSocial.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        this.txtRazonSocial.setVisible(false);
        this.txtRazonSocial.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblMontoDelBeneficio = new Label(container, 0);
        lblMontoDelBeneficio.setText("Monto del Beneficio Individual");
        this.txtMontoIndividual = new Text(container, 2048);
        this.txtMontoIndividual.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoInfoBeneficiario.this.txtMontoIndividual.selectAll();
            }
        });
        this.txtMontoIndividual.setTextLimit(15);
        GridData gd_txtMontoIndividual = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtMontoIndividual.widthHint = 100;
        this.txtMontoIndividual.setLayoutData((Object)gd_txtMontoIndividual);
        Label lblPorcentajeRetencin = new Label(container, 0);
        lblPorcentajeRetencin.setText("Porcentaje Retenci\u00f3n");
        this.txtPorcentajeRetencion = new Text(container, 2048);
        this.txtPorcentajeRetencion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoInfoBeneficiario.this.txtPorcentajeRetencion.selectAll();
            }
        });
        this.txtPorcentajeRetencion.setTextLimit(15);
        GridData gd_txtPorcentajeRetencion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtPorcentajeRetencion.widthHint = 100;
        this.txtPorcentajeRetencion.setLayoutData((Object)gd_txtPorcentajeRetencion);
        Label lblMontoRetencin = new Label(container, 0);
        lblMontoRetencin.setText("Monto Retenci\u00f3n");
        this.txtMontoRetencion = new Text(container, 2048);
        this.txtMontoRetencion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoInfoBeneficiario.this.txtMontoRetencion.selectAll();
            }
        });
        this.txtMontoRetencion.setTextLimit(15);
        GridData gd_txtMontoRetencion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtMontoRetencion.widthHint = 100;
        this.txtMontoRetencion.setLayoutData((Object)gd_txtMontoRetencion);
        Label lblFechaDePago = new Label(container, 0);
        lblFechaDePago.setText("Fecha de Pago del Dividendo");
        final CDateTime dtFechaPagoDiv = new CDateTime(container, 32771);
        dtFechaPagoDiv.setPattern("dd/MM/yyyy");
        dtFechaPagoDiv.setNullText(" ");
        GridData gd_dtFechaPagoDiv = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_dtFechaPagoDiv.widthHint = 125;
        dtFechaPagoDiv.setLayoutData((Object)gd_dtFechaPagoDiv);
        dtFechaPagoDiv.setSelection(this.modeloDatos.getFechaPagoDiv());
        dtFechaPagoDiv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogoInfoBeneficiario.this.modeloDatos.setFechaPagoDiv(dtFechaPagoDiv.getSelection());
            }
        });
        dtFechaPagoDiv.setEnabled(this.esDentroPeriodo2015());
        Label lblRentDiv = new Label(container, 0);
        GridData gd_lblRentDiv = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRentDiv.widthHint = 320;
        lblRentDiv.setLayoutData((Object)gd_lblRentDiv);
        lblRentDiv.setText("Impuesto a la Renta Correspondiente al Dividendo");
        this.txtImpRentaDiv = new Text(container, 2048);
        this.txtImpRentaDiv.setTextLimit(15);
        GridData gd_txtImpRentaDiv = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtImpRentaDiv.widthHint = 100;
        this.txtImpRentaDiv.setLayoutData((Object)gd_txtImpRentaDiv);
        this.txtImpRentaDiv.setEnabled(this.esDentroPeriodo2015());
        Label lblAnioGenUtilDiv = new Label(container, 0);
        GridData gd_lblAnioGenUtilDiv = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblAnioGenUtilDiv.widthHint = 350;
        lblAnioGenUtilDiv.setLayoutData((Object)gd_lblAnioGenUtilDiv);
        lblAnioGenUtilDiv.setText("A\u00f1o en que se Generaron las Utilidades Atribuibles al Dividendo");
        this.txtAnioGenUtilDiv = new Text(container, 2048);
        this.txtAnioGenUtilDiv.setTextLimit(4);
        GridData gd_txtAnioGenUtilDiv = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtAnioGenUtilDiv.widthHint = 100;
        this.txtAnioGenUtilDiv.setLayoutData((Object)gd_txtAnioGenUtilDiv);
        this.txtAnioGenUtilDiv.setEnabled(this.esDentroPeriodo2015());
        Label lblInformacinDelPago = new Label(container, 0);
        GridData gd_lblInformacinDelPago = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblInformacinDelPago.verticalIndent = 10;
        lblInformacinDelPago.setLayoutData((Object)gd_lblInformacinDelPago);
        lblInformacinDelPago.setText("Informaci\u00f3n del Pago");
        lblInformacinDelPago.setFont(SWTResourceManager.getBoldFont((Font)lblInformacinDelPago.getFont()));
        new Label(container, 0);
        Label lblPagoAResidente = new Label(container, 0);
        GridData gd_lblPagoAResidente = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPagoAResidente.widthHint = 180;
        lblPagoAResidente.setLayoutData((Object)gd_lblPagoAResidente);
        lblPagoAResidente.setText("Pago a residente o no residente");
        this.cvPago = new ComboViewer(container, 8);
        this.comboTipoPagoSelectionChanged();
        this.cmbPago = this.cvPago.getCombo();
        GridData gd_cmbPago = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbPago.widthHint = 125;
        this.cmbPago.setLayoutData((Object)gd_cmbPago);
        this.compFiscalidad.crearComponenteFiscalidad(container, false);
        Label label_2 = new Label(container, 0);
        GridData gd_label_2 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_label_2.widthHint = 195;
        label_2.setLayoutData((Object)gd_label_2);
        label_2.setText("\u00bfAplica convenio doble tributaci\u00f3n?");
        Composite composite = new Composite(container, 0);
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        this.btnConvenioSi = new Button(composite, 16);
        this.btnConvenioSi.setEnabled(false);
        GridData gd_btnConvenioSi = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnConvenioSi.widthHint = 50;
        this.btnConvenioSi.setLayoutData((Object)gd_btnConvenioSi);
        this.btnConvenioSi.setText("SI");
        this.btnConvenioNo = new Button(composite, 16);
        this.btnConvenioNo.setEnabled(false);
        GridData gd_btnConvenioNo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnConvenioNo.widthHint = 50;
        this.btnConvenioNo.setLayoutData((Object)gd_btnConvenioNo);
        this.btnConvenioNo.setText("NO");
        Label lblesPagoAl = new Label(container, 0);
        GridData gd_lblesPagoAl = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblesPagoAl.widthHint = 370;
        lblesPagoAl.setLayoutData((Object)gd_lblesPagoAl);
        lblesPagoAl.setText("\u00bfEs pago al exterior sujeto a retenci\u00f3n en aplicaci\u00f3n a la norma legal?");
        Composite composite_1 = new Composite(container, 0);
        GridLayout gl_composite_1 = new GridLayout(2, false);
        gl_composite_1.marginHeight = 0;
        gl_composite_1.marginWidth = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        this.btnRetencionSi = new Button(composite_1, 16);
        this.btnRetencionSi.setEnabled(false);
        GridData gd_btnRetencionSi = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnRetencionSi.widthHint = 50;
        this.btnRetencionSi.setLayoutData((Object)gd_btnRetencionSi);
        this.btnRetencionSi.setText("SI");
        this.btnRetencionNo = new Button(composite_1, 16);
        this.btnRetencionNo.setEnabled(false);
        GridData gd_btnRetencionNo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnRetencionNo.widthHint = 50;
        this.btnRetencionNo.setLayoutData((Object)gd_btnRetencionNo);
        this.btnRetencionNo.setText("NO");
        this.lblPagoRegimenFiscal = new Label(container, 0);
        GridData gd_lblPagoRegimenFiscal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPagoRegimenFiscal.widthHint = 342;
        this.lblPagoRegimenFiscal.setLayoutData((Object)gd_lblPagoRegimenFiscal);
        this.lblPagoRegimenFiscal.setText("\u00bfEs pago a un r\u00e9gimen fiscal preferente o de menor imposici\u00f3n?");
        this.panelPagoRegFiscal = new Composite(container, 0);
        GridLayout gl_panelPagoRegFiscal = new GridLayout(2, false);
        gl_panelPagoRegFiscal.marginWidth = 0;
        gl_panelPagoRegFiscal.marginHeight = 0;
        this.panelPagoRegFiscal.setLayout((Layout)gl_panelPagoRegFiscal);
        this.btnPagRegFis_SI = new Button(this.panelPagoRegFiscal, 16);
        this.btnPagRegFis_SI.setEnabled(false);
        GridData gd_btnPagRegFis_SI = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnPagRegFis_SI.widthHint = 50;
        this.btnPagRegFis_SI.setLayoutData((Object)gd_btnPagRegFis_SI);
        this.btnPagRegFis_SI.setText("SI");
        this.btnPagRegFis_NO = new Button(this.panelPagoRegFiscal, 16);
        this.btnPagRegFis_NO.setEnabled(false);
        GridData gd_btnPagRegFis_NO = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnPagRegFis_NO.widthHint = 50;
        this.btnPagRegFis_NO.setLayoutData((Object)gd_btnPagRegFis_NO);
        this.btnPagRegFis_NO.setText("NO");
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    private void comboTipoPagoSelectionChanged() {
        this.cvPago.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoPago = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoPago != null) {
                    DialogoInfoBeneficiario.this.modeloDatos.getPagoLocalExterior().getFiscalidad().setTipoPago((String)tipoPago.getValor());
                    DialogoInfoBeneficiario.this.modeloDatos.getPagoLocalExterior().getFiscalidad().setDescripcionTipoPago(tipoPago.getNombre());
                    DialogoInfoBeneficiario.this.habilitarInformacionDelPagoDesdeEnero2013((ElementoNombreValor<String>)tipoPago);
                    DialogoInfoBeneficiario.this.compFiscalidad.habilitarPagoExteriorLuegoDeLaSeleccionDelTipoDePago("02".equals(tipoPago.getValor()));
                }
            }
        });
    }

    public void manejarSeleccionComboTipoIdBeneficiario() {
        this.cvTipoIdentificacion.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoIdentificacion = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoIdentificacion != null) {
                    DialogoInfoBeneficiario.this.renderizarParteRelacionadaEnBaseAlPeriodo();
                    DialogoInfoBeneficiario.this.modeloDatos.getBeneficiario().setTipoIdentificacion((String)tipoIdentificacion.getValor());
                    DialogoInfoBeneficiario.this.modeloDatos.getBeneficiario().setDescripcionTipoIdentificacion(tipoIdentificacion.getNombre());
                    DialogoInfoBeneficiario.this.mostarTipoDeBeneficiarioyRazonSocialDesdeMayo2016((ElementoNombreValor<String>)tipoIdentificacion);
                }
            }
        });
    }

    protected void mostarTipoDeBeneficiarioyRazonSocialDesdeMayo2016(ElementoNombreValor<String> tipoIdentificacion) {
        boolean esPasaporteYPeriodoDesdeMayo2016 = "P".equals(tipoIdentificacion.getValor()) && this.periodo.isAnexoEnPeriodoDesdeMayo2016();
        this.lblRazonSocial.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.txtRazonSocial.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.lblTipoDeBeneficiario.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.cmbTipoDeBeneficiario.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        if (!esPasaporteYPeriodoDesdeMayo2016) {
            this.txtRazonSocial.setText("");
        }
    }

    private void renderizarParteRelacionadaEnBaseAlPeriodo() {
        this.lblParteRelacionada.setVisible(this.esDentroPeriodo2015());
        this.panelBotonesPr.setVisible(this.esDentroPeriodo2015());
    }

    private boolean esDentroPeriodo2015() {
        return ((Iva)this.modeloDatos.getRaizModelo()).periodo.isPeriodoDeAnexoDesdeMarzo2015();
    }

    public void procesarModeloDatos() {
        boolean esPagoANoResidente = false;
        String codigoTipoIdentificacion = this.modeloDatos.getBeneficiario().getTipoIdentificacion();
        ElementoNombreValor tipoIdentificacion = this.modeloValores.obtenerTipoIdentificacion(codigoTipoIdentificacion);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoIdentificacion, (Object)tipoIdentificacion);
        String codigoPago = this.modeloDatos.getPagoLocalExterior().getFiscalidad().getTipoPago();
        ElementoNombreValor tipoPago = this.modeloValores.obtenerTipoPago(codigoPago);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvPago, (Object)tipoPago);
        String tipoBeneficiario = this.modeloDatos.getBeneficiario().getTipoProveedor();
        ElementoNombreValor elementoTipoRetenido = this.modeloValores.obtenerTipoDeBeneficiario(tipoBeneficiario);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvBeneficiario, (Object)elementoTipoRetenido);
        if (codigoTipoIdentificacion == null) {
            this.lblParteRelacionada.setVisible(false);
            this.panelBotonesPr.setVisible(false);
        }
        this.compFiscalidad.inicializarViews();
        if (tipoPago != null) {
            esPagoANoResidente = "02".equals(tipoPago.getValor());
            this.compFiscalidad.determinarTipoRegimen();
            this.habilitarInformacionDelPagoDesdeEnero2013((ElementoNombreValor<String>)tipoPago);
        }
        this.compFiscalidad.habilitarConvenioYRetencionParaPagoExteriorModoEdicion(esPagoANoResidente);
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidable)this.modeloDatos, this){

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                if (!DialogoInfoBeneficiario.this.modeloDatos.getBeneficiario().equals((Object)DialogoInfoBeneficiario.this.beneficiarioActual)) {
                    Sujeto sujetoTemporal = new Sujeto();
                    sujetoTemporal.setTipoIdentificacion(DialogoInfoBeneficiario.this.modeloDatos.getBeneficiario().getTipoIdentificacion());
                    sujetoTemporal.setIdentificacion(DialogoInfoBeneficiario.this.modeloDatos.getBeneficiario().getIdentificacion());
                    if (DialogoInfoBeneficiario.this.beneficiariosExistentes.contains(sujetoTemporal)) {
                        resultado.fallarValidacion("El Beneficiario ya se encuentra registrado para el Fondo o Fideicomiso");
                    }
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getBeneficiario().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getPagoLocalExterior().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getPagoLocalExterior().getFiscalidad().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    private void habilitarInformacionDelPagoDesdeEnero2013(ElementoNombreValor<String> tipoPago) {
        if (tipoPago != null) {
            boolean esPagoANoResidenteYPeriodoDesdeEnero2013 = "02".equals(tipoPago.getValor()) && this.periodo.isPeriodoDesdeEnero2013();
            this.btnConvenioSi.setEnabled(esPagoANoResidenteYPeriodoDesdeEnero2013);
            this.btnConvenioNo.setEnabled(esPagoANoResidenteYPeriodoDesdeEnero2013);
            this.btnRetencionNo.setEnabled(esPagoANoResidenteYPeriodoDesdeEnero2013 && !this.modeloDatos.getPagoLocalExterior().isConvenioDobleTributacion());
            this.btnRetencionSi.setEnabled(esPagoANoResidenteYPeriodoDesdeEnero2013 && !this.modeloDatos.getPagoLocalExterior().isConvenioDobleTributacion());
            this.habilitarRegimenFiscalPreferenteDesdeMarzo2015HastaAbril2016("02".equals(tipoPago.getValor()));
        }
    }

    private void habilitarRegimenFiscalPreferenteDesdeMarzo2015HastaAbril2016(boolean esPagoANoResidente) {
        this.btnPagRegFis_SI.setEnabled(esPagoANoResidente && this.periodo.isPeriodoDeAnexoDesdeMarzo2015() && this.periodo.isAnexoEnPeriodoHastaAbril2016());
        this.btnPagRegFis_NO.setEnabled(esPagoANoResidente && this.periodo.isPeriodoDeAnexoDesdeMarzo2015() && this.periodo.isAnexoEnPeriodoHastaAbril2016());
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvPago.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvPago.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposPagosModeloValoresObserveList = PojoProperties.list((String)"tiposPagos").observe((Object)this.modeloValores);
        this.cvPago.setInput((Object)tiposPagosModeloValoresObserveList);
        ISWTObservableValue observeTextTxtNumIdentificacionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumIdentificacion);
        IObservableValue beneficiarioidentificacionModeloDatosObserveValue = BeanProperties.value((String)"beneficiario.identificacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumIdentificacionObserveWidget, beneficiarioidentificacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtMontoIndividualObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMontoIndividual);
        IObservableValue montoBeneficioIndividualModeloDatosObserveValue = BeanProperties.value((String)"montoBeneficioIndividual").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtMontoIndividualObserveWidget, montoBeneficioIndividualModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtMontoRetencionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMontoRetencion);
        IObservableValue montoRentencionRentaModeloDatosObserveValue = BeanProperties.value((String)"montoRentencionRenta").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtMontoRetencionObserveWidget, montoRentencionRentaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPorcentajeRetencionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPorcentajeRetencion);
        IObservableValue porcentajeRetencionModeloDatosObserveValue = BeanProperties.value((String)"porcentajeRetencion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPorcentajeRetencionObserveWidget, porcentajeRetencionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionButtonObserveWidget = WidgetProperties.selection().observe((Widget)this.btnConvenioSi);
        IObservableValue pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue = BeanProperties.value((String)"pagoLocalExterior.convenioDobleTributacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionButtonObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionButton_1ObserveWidget = WidgetProperties.selection().observe((Widget)this.btnConvenioNo);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)observeSelectionButton_1ObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, strategy, strategy_1);
        ISWTObservableValue observeSelectionButton_2ObserveWidget = WidgetProperties.selection().observe((Widget)this.btnRetencionSi);
        IObservableValue pagoLocalExteriorsujetoNormaLegalModeloDatosObserveValue = BeanProperties.value((String)"pagoLocalExterior.sujetoNormaLegal").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionButton_2ObserveWidget, pagoLocalExteriorsujetoNormaLegalModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionButton_3ObserveWidget = WidgetProperties.selection().observe((Widget)this.btnRetencionNo);
        UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
        strategy_2.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
        strategy_3.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)observeSelectionButton_3ObserveWidget, pagoLocalExteriorsujetoNormaLegalModeloDatosObserveValue, strategy_2, strategy_3);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap observeMap_2 = PojoObservables.observeMap((IObservableSet)listContentProvider_2.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoIdentificacion.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_2));
        this.cvTipoIdentificacion.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList tiposIdentificacionModeloValoresObserveList = PojoProperties.list((String)"tiposIdentificacion").observe((Object)this.modeloValores);
        this.cvTipoIdentificacion.setInput((Object)tiposIdentificacionModeloValoresObserveList);
        ISWTObservableValue btnSiPrObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnSiPr);
        IObservableValue modeloDatosParteRelacionadaObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"parteRelacionada");
        bindingContext.bindValue((IObservableValue)btnSiPrObserveSelectionObserveWidget, modeloDatosParteRelacionadaObserveValue, null, null);
        ISWTObservableValue btnNoPrObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnNoPr);
        UpdateValueStrategy strategy_4 = new UpdateValueStrategy();
        strategy_4.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_5 = new UpdateValueStrategy();
        strategy_5.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoPrObserveSelectionObserveWidget, modeloDatosParteRelacionadaObserveValue, strategy_4, strategy_5);
        ISWTObservableValue txtImpRentaDivObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtImpRentaDiv, (int)24);
        IObservableValue modeloDatosImpRentSocObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"impRentSoc");
        bindingContext.bindValue((IObservableValue)txtImpRentaDivObserveTextObserveWidget, modeloDatosImpRentSocObserveValue, null, null);
        ISWTObservableValue txtAnioGenUtilDivObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtAnioGenUtilDiv, (int)24);
        IObservableValue modeloDatosAnioGerUtilDivObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"anioGerUtilDiv");
        bindingContext.bindValue((IObservableValue)txtAnioGenUtilDivObserveTextObserveWidget, modeloDatosAnioGerUtilDivObserveValue, null, null);
        ISWTObservableValue btnPagRegFis_SIObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnPagRegFis_SI);
        IObservableValue modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"pagoLocalExterior.pagoRegimenFiscal");
        bindingContext.bindValue((IObservableValue)btnPagRegFis_SIObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, null, null);
        ISWTObservableValue btnPagRegFis_NOObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnPagRegFis_NO);
        UpdateValueStrategy strategy_6 = new UpdateValueStrategy();
        strategy_6.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_7 = new UpdateValueStrategy();
        strategy_7.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnPagRegFis_NOObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, strategy_6, strategy_7);
        ISWTObservableValue btnRetencionSiObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.btnRetencionSi);
        UpdateValueStrategy strategy_8 = new UpdateValueStrategy();
        strategy_8.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnRetencionSiObserveEnabledObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, null, strategy_8);
        ISWTObservableValue btnRetencionNoObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.btnRetencionNo);
        UpdateValueStrategy strategy_9 = new UpdateValueStrategy();
        strategy_9.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnRetencionNoObserveEnabledObserveWidget, pagoLocalExteriorconvenioDobleTributacionModeloDatosObserveValue, null, strategy_9);
        ISWTObservableValue txtRazonSocialObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRazonSocial, (int)24);
        IObservableValue modeloDatosBeneficiariorazonSocialObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"beneficiario.razonSocial");
        bindingContext.bindValue((IObservableValue)txtRazonSocialObserveTextObserveWidget, modeloDatosBeneficiariorazonSocialObserveValue, null, null);
        ObservableListContentProvider listContentProvider_3 = new ObservableListContentProvider();
        IObservableMap observeMap_3 = PojoObservables.observeMap((IObservableSet)listContentProvider_3.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvBeneficiario.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_3));
        this.cvBeneficiario.setContentProvider((IContentProvider)listContentProvider_3);
        IObservableList modeloValoresTiposDeBeneficiariosObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposDeBeneficiarios");
        this.cvBeneficiario.setInput((Object)modeloValoresTiposDeBeneficiariosObserveList);
        ISWTObservableValue cmbPagoObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.cmbPago);
        IObservableValue periodoPeriodoDesdeEnero2013ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"periodoDesdeEnero2013");
        bindingContext.bindValue((IObservableValue)cmbPagoObserveEnabledObserveWidget, periodoPeriodoDesdeEnero2013ObserveValue, null, null);
        ISWTObservableValue lblPagoRegimenFiscalObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblPagoRegimenFiscal);
        IObservableValue periodoAnexoEnPeriodoDesdeMarzo2015HastaAbril2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoDesdeMarzo2015HastaAbril2016");
        bindingContext.bindValue((IObservableValue)lblPagoRegimenFiscalObserveVisibleObserveWidget, periodoAnexoEnPeriodoDesdeMarzo2015HastaAbril2016ObserveValue, null, null);
        ISWTObservableValue panelPagoRegFiscalObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.panelPagoRegFiscal);
        bindingContext.bindValue((IObservableValue)panelPagoRegFiscalObserveVisibleObserveWidget, periodoAnexoEnPeriodoDesdeMarzo2015HastaAbril2016ObserveValue, null, null);
        this.compFiscalidad.initDataBindingsFiscaldiad(bindingContext, (ObjetoModelo)this.modeloDatos);
        return bindingContext;
    }
}

